<?php
/*--------------------------------------------------------------
   Resized.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Events;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Height;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Id;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Width;

class Resized
{
    /**
     * @var Id
     */
    private $id;
    
    /**
     * @var Height
     */
    private $height;
    
    /**
     * @var Width
     */
    private $width;
    
    
    /**
     * Constructor.
     */
    private function __construct(
        Id $id,
        Width $width,
        Height $height
    ) {
        $this->id     = $id;
        $this->width  = $width;
        $this->height = $height;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(
        Id $id,
        Width $width,
        Height $height
    ): self {
        return new self($id, $width, $height);
    }
    
    
    /**
     * Return ID.
     */
    public function id(): Id
    {
        return $this->id;
    }
    
    
    /**
     * Return height.
     */
    public function height(): Height
    {
        return $this->height;
    }
    
    
    /**
     * Return width.
     */
    public function width(): Width
    {
        return $this->width;
    }
}